/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

float kSpeed = 0.2;

// Fuzzy circle with radius .5 centered at (.5, .5).
float circle(in vec2 uv)
{
    float r = .5;
    vec2 center = vec2(r, r);
    float d = distance(uv, center);
    return step(d, r) * pow(abs(1.-d), 4.);
}

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float minResolution = min(iResolution.x, iResolution.y);
    vec2 uv = fragCoord.xy / minResolution;
    float time = iGlobalTime * kSpeed;

    float sets[5];

    // First set:
    vec2 p = uv;
    p.x += sin(3.*p.y)*sin(2.*p.x + time);
    p = abs(p);
    sets[0] = circle(mod(p, .2)*7.);

    // Second set:
    p = uv;
    p.y += sin(10.*p.y)*sin(2.3*p.x + .8*time);
    p = abs(p);
    sets[1] = circle(mod(p*.6, .2)*7.);

    // Third set:
    p = uv;
    p.y += sin(10.*p.x)*sin(2.3*p.y + 2.*time);
    p.x += sin(p.y)*sin(p.x) + sin(time);
    p = abs(p);
    sets[2] = circle(mod(p*.4, .2)*4.);

    // Fourth set:
    p = uv;
    p.y += sin(5.*p.x)*sin(2.*p.y + 1.4*time);
    p.x += sin(5.*p.y)*sin(p.x) + sin(time);
    p = abs(p);
    sets[3] = circle(mod(p, .4)*3.);

    // Fifth set:
    p = uv;
    p.x += sin(2.*uv.y)*sin(5.*uv.x + 2.5*time);
    p.y += sin(2.*uv.x)*sin(5.*uv.x + 2.0*time);
    p = abs(p);
    sets[4] = circle(mod(p, .2)*5.);

    fragColor = vec4(0.0);
    fragColor.xy += sets[0];
    fragColor.yz += sets[1];
    fragColor.xz += sets[2];
    fragColor.y += 0.5*sets[3];
    fragColor.xyz += vec3(0.2, 0.4, 0.7)*sets[4];
    fragColor.w = length(fragColor.xyz);
}

// main added by TheEmu.

void main (void) {
  mainImage ( gl_FragColor, gl_FragCoord.xy );
}